/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerRegistry;
import com.blamejared.crafttweaker.api.ScriptLoadingOptions;
import com.blamejared.crafttweaker.api.logger.LogLevel;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.zencode.brackets.CTRegisterBEPEvent;
import com.blamejared.crafttweaker.impl.brackets.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.impl.brackets.tags.TagBracketHandler;
import com.blamejared.crafttweaker.impl.brackets.tags.TagManagerBracketHandler;
import com.blamejared.crafttweaker.impl.commands.CTCommands;
import com.blamejared.crafttweaker.impl.commands.custom.CustomCommands;
import com.blamejared.crafttweaker.impl.events.CTClientEventHandler;
import com.blamejared.crafttweaker.impl.events.CTEventHandler;
import com.blamejared.crafttweaker.impl.logger.GroupLogger;
import com.blamejared.crafttweaker.impl.loot.conditions.LootConditionManager;
import com.blamejared.crafttweaker.impl.managers.CTCraftingTableManager;
import com.blamejared.crafttweaker.impl.network.PacketHandler;
import com.blamejared.crafttweaker.impl.script.ScriptRecipe;
import com.blamejared.crafttweaker.impl.tag.registry.CrTTagRegistryData;
import com.mojang.brigadier.CommandDispatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.command.CommandSource;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="crafttweaker")
public class CraftTweaker {
    public static final String MODID = "crafttweaker";
    public static final String NAME = "CraftTweaker";
    public static final String VERSION = "6.0.0";
    public static final Logger LOG = LogManager.getLogger((String)"CraftTweaker");
    public static final UUID CRAFTTWEAKER_UUID = UUID.nameUUIDFromBytes("crafttweaker".getBytes());
    public static boolean serverOverride = true;
    private static Set<String> PATRON_LIST = new HashSet<String>();
    public static IRecipeType<ScriptRecipe> RECIPE_TYPE_SCRIPTS;

    public CraftTweaker() {
        if (!(CraftTweakerAPI.SCRIPT_DIR.exists() || CraftTweakerAPI.SCRIPT_DIR.mkdirs() || CraftTweakerAPI.SCRIPT_DIR.mkdir())) {
            String path = CraftTweakerAPI.SCRIPT_DIR.getAbsolutePath();
            throw new IllegalStateException("Could not create Directory " + path);
        }
        CraftTweakerAPI.setupLoggers();
        CraftTweakerAPI.logger.setLogLevel(LogLevel.INFO);
        CraftTweakerAPI.logInfo("Starting building internal Registries", new Object[0]);
        CraftTweakerRegistry.addAdvancedBEPName("recipemanager");
        CraftTweakerRegistry.findClasses();
        LootConditionManager.handleBuilderRegistration();
        CraftTweakerAPI.logInfo("Completed building internal Registries", new Object[0]);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, EventPriority.HIGHEST, this::handleTags);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new CTEventHandler());
        PacketHandler.init();
        RECIPE_TYPE_SCRIPTS = IRecipeType.func_222147_a((String)"crafttweaker:scripts");
        CraftTweakerRegistries.init();
        new Thread(() -> {
            try {
                URL url = new URL("https://blamejared.com/patrons.txt");
                URLConnection urlConnection = url.openConnection();
                urlConnection.setConnectTimeout(15000);
                urlConnection.setReadTimeout(15000);
                urlConnection.setRequestProperty("User-Agent", "CraftTweaker|1.16.4");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));){
                    PATRON_LIST = reader.lines().filter(s -> !s.isEmpty()).collect(Collectors.toSet());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
    }

    private static void giveFeedback(ITextComponent msg) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.func_184103_al().func_232641_a_(msg, ChatType.SYSTEM, CRAFTTWEAKER_UUID);
        } else {
            LOG.info(msg.getString());
        }
    }

    private void handleTags(RegistryEvent<Block> ignored) {
        CraftTweakerAPI.logDebug("Setting up Tag Managers", new Object[0]);
        CrTTagRegistryData.INSTANCE.registerForgeTags();
        CraftTweakerAPI.logDebug("Finished setting up Tag Managers", new Object[0]);
    }

    private void setup(FMLCommonSetupEvent event) {
        ScriptLoadingOptions setupCommon = new ScriptLoadingOptions().setLoaderName("setupCommon").execute();
        CraftTweakerAPI.loadScripts(setupCommon);
        CTCommands.initArgumentTypes();
        LOG.info("{} has loaded successfully!", (Object)NAME);
    }

    private void setupClient(FMLClientSetupEvent event) {
        LOG.info("{} client has loaded successfully!", (Object)NAME);
        MinecraftForge.EVENT_BUS.register((Object)new CTClientEventHandler());
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ((GroupLogger)CraftTweakerAPI.logger).addPlayerLogger(event.getPlayer());
    }

    @SubscribeEvent
    public void playerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ((GroupLogger)CraftTweakerAPI.logger).removePlayerLogger(event.getPlayer());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void getRecipes(RecipesUpdatedEvent event) {
        if (((Map)event.getRecipeManager().field_199522_d.getOrDefault(RECIPE_TYPE_SCRIPTS, new HashMap())).size() == 0) {
            return;
        }
        RecipeManager recipeManager = event.getRecipeManager();
        recipeManager.field_199522_d = new HashMap(recipeManager.field_199522_d);
        recipeManager.field_199522_d.replaceAll((t, v) -> new HashMap((Map)recipeManager.field_199522_d.get(t)));
        serverOverride = false;
        CTCraftingTableManager.recipeManager = event.getRecipeManager();
        ScriptLoadingOptions scriptLoadingOptions = new ScriptLoadingOptions().execute();
        CraftTweakerAPI.loadScriptsFromRecipeManager(event.getRecipeManager(), scriptLoadingOptions);
    }

    @SubscribeEvent
    public void registerBracketExpressionParsers(CTRegisterBEPEvent event) {
        List<Class<? extends IRecipeManager>> recipeManagers = CraftTweakerRegistry.getRecipeManagers();
        event.registerBEP("recipetype", new RecipeTypeBracketHandler(recipeManagers));
        TagManagerBracketHandler tagManagerBEP = new TagManagerBracketHandler(CrTTagRegistryData.INSTANCE);
        event.registerBEP("tagManager", tagManagerBEP);
        event.registerBEP("tag", new TagBracketHandler(tagManagerBEP));
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        CTCommands.init((CommandDispatcher<CommandSource>)event.getDispatcher());
        CustomCommands.init((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void resourceReload(final AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new ReloadListener<Void>(){

            @Nonnull
            @ParametersAreNonnullByDefault
            protected Void prepare(IResourceManager resourceManagerIn, IProfiler profilerIn) {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                serverOverride = server == null;
                return null;
            }

            @ParametersAreNonnullByDefault
            protected void apply(Void objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
                String name;
                CraftTweaker.giveFeedback((ITextComponent)new StringTextComponent("CraftTweaker reload starting!"));
                RecipeManager recipeManager = event.getDataPackRegistries().func_240967_e_();
                recipeManager.field_199522_d = new HashMap(recipeManager.field_199522_d);
                recipeManager.field_199522_d.replaceAll((t, v) -> new HashMap((Map)recipeManager.field_199522_d.get(t)));
                CTCraftingTableManager.recipeManager = recipeManager;
                CraftTweakerAPI.loadScripts(new ScriptLoadingOptions().execute());
                List<File> scriptFiles = CraftTweakerAPI.getScriptFiles();
                scriptFiles.stream().map(file -> new ScriptRecipe(new ResourceLocation(CraftTweaker.MODID, file.getPath().substring("scripts\\".length()).replaceAll("[^a-z0-9_.-]", "_")), file.getPath().substring("scripts\\".length()), CraftTweaker.this.readContents((File)file))).forEach(scriptRecipe -> {
                    Map map = recipeManager.field_199522_d.computeIfAbsent(RECIPE_TYPE_SCRIPTS, iRecipeType -> new HashMap());
                    map.put(scriptRecipe.func_199560_c(), scriptRecipe);
                });
                StringTextComponent msg = new StringTextComponent("CraftTweaker reload complete!");
                CraftTweaker.giveFeedback((ITextComponent)msg);
                if (scriptFiles.size() > 0 && !CraftTweakerAPI.NO_BRAND && !(name = PATRON_LIST.stream().skip(PATRON_LIST.isEmpty() ? 0L : (long)new Random().nextInt(PATRON_LIST.size())).findFirst().orElse("")).isEmpty()) {
                    CraftTweakerAPI.logInfo("This reload was made possible by " + name + " and more! Become a patron at https://patreon.com/jaredlll08?s=crtmod", new Object[0]);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readContents(File file) {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string = bufferedReader.lines().collect(Collectors.joining("\r\n"));
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

